package org.msh.tb.bd.tbforms.indicator.detailed;

import org.msh.tb.bd.Quarter;
import org.msh.tb.cases.CaseItemData;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;
import org.msh.tb.entities.enums.Gender;
import org.msh.tb.indicators.core.IndicatorFilters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Utils used by TBFormCasesQuery
 * Created on 29/01/2018 by mauricio
 */
public class TBFormCasesQueryUtils {

    /**
     * @return The where clause of HQL that will retrieve the result list and result count.
     * This method will concatenate:
     * - The location (workspace, adminunit or tbunit) condition,
     * - The time condition (initial date and end date)
     * - The specific conditions of the TBForm
     * - The cell condition
     */
    public static String getHQLWhere(IndicatorFilters indicatorFilters, Workspace workspace, Map<String, Object> queryParams, String cellCondition) {
        Tbunit tbunit = indicatorFilters.getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = indicatorFilters.getTbunitselection().getLastLevelAdminUnitSelected();
        Quarter selectedQuarter = indicatorFilters.getQuarter();

        // Start where clause with period condition
        String whereHQL = "where c.registrationDate between :iniDate and :endDate ";
        queryParams.put("iniDate", selectedQuarter.getIniDate());
        queryParams.put("endDate", selectedQuarter.getEndDate());

        // add location condition
        if (tbunit != null) {
            // add tbunit restriction
            whereHQL = whereHQL.concat("and c.notificationUnit.id = :unitId");
            queryParams.put("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction
            whereHQL = whereHQL.concat("and c.notificationUnit.adminUnit.code like :code");
            queryParams.put("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction
            whereHQL = whereHQL.concat("and c.patient.workspace.id = :wsId");
            queryParams.put("wsId", workspace.getId());
        } else {
            throw new RuntimeException("TbFormDbService: Tbunit, adminunit or workspace must be set.");
        }

        return whereHQL.concat(" ")
                .concat(cellCondition).concat(" ");
    }


    /**
     * Parses the array of objects into a CaseItemData.
     * @param res The query result
     * @return The query result parsed into a List of CaseItemData
     */
    public static List<CaseItemData> parseResult(List<Object[]> res) {
        List<CaseItemData> parsed = new ArrayList<CaseItemData>();
        for (Object[] o : res) {
            parsed.add(new CaseItemData((Integer) o[0], (String) o[1], (Integer) o[2], (Integer) o[3], (Gender) o[4]));
        }
        return parsed;
    }

}
